/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.config.Config;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.joml.Vector3f;

public abstract class AircraftEntity
extends EngineVehicle {
    protected double lastY;
    private static final List<Trail> TRAILS = Collections.emptyList();

    public AircraftEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super((class_1299<? extends EngineVehicle>)entityType, world, canExplodeOnCrash);
    }

    public List<Trail> getTrails() {
        return TRAILS;
    }

    @Override
    public void method_5773() {
        this.prevRoll = this.roll;
        if (this.method_24828()) {
            this.setZRot(this.roll * 0.9f);
        } else {
            this.setZRot(-this.pressingInterpolatedX.getSmooth() * this.getProperties().get(VehicleStat.ROLL_FACTOR));
        }
        if (Double.isNaN(this.method_18798().field_1352) || Double.isNaN(this.method_18798().field_1351) || Double.isNaN(this.method_18798().field_1350)) {
            this.method_18800(0.0, 0.0, 0.0);
        }
        super.method_5773();
    }

    protected void convertPower(class_243 direction) {
        class_243 velocity = this.method_18798();
        double drag = Math.abs(direction.method_1026(velocity.method_1029()));
        this.method_18799(velocity.method_1029().method_35590(direction, (double)this.getProperties().get(VehicleStat.LIFT)).method_1021(velocity.method_1033() * (drag * (double)this.getProperties().get(VehicleStat.FRICTION) + (1.0 - (double)this.getProperties().get(VehicleStat.FRICTION)))));
    }

    @Override
    protected float getGroundDecay() {
        float gravity = Math.min(1.0f, Math.max(0.0f, this.getGravity() / -0.04f));
        float upgrade = Math.min(1.0f, this.getProperties().get(VehicleStat.ACCELERATION) * 0.5f);
        return (super.getGroundDecay() * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    @Override
    protected void updateController() {
        this.method_36456(this.method_36454() - this.getProperties().get(VehicleStat.YAW_SPEED) * this.pressingInterpolatedX.getSmooth());
        if (!this.method_24828()) {
            this.method_36457(this.method_36455() + this.getProperties().get(VehicleStat.PITCH_SPEED) * this.pressingInterpolatedZ.getSmooth());
        }
        this.method_36457(this.method_36455() * (1.0f - this.getProperties().getAdditive(VehicleStat.STABILIZER)));
    }

    @Override
    protected void updateVelocity() {
        Vector3f direction = this.getForwardDirection();
        float diff = (float)(this.lastY - this.method_23318());
        if (this.lastY != 0.0 && this.getProperties().get(VehicleStat.GLIDE_FACTOR) > 0.0f && (double)diff != 0.0) {
            this.method_18799(this.method_18798().method_1019(this.toVec3d(direction).method_1021((double)(diff * this.getProperties().get(VehicleStat.GLIDE_FACTOR) * (1.0f - Math.abs(direction.y))))));
        }
        this.lastY = (float)this.method_23318();
        this.convertPower(this.toVec3d(direction));
        this.applyFriction();
        if (this.method_24828()) {
            this.method_36457((this.method_36455() + this.getProperties().get(VehicleStat.GROUND_PITCH)) * 0.9f - this.getProperties().get(VehicleStat.GROUND_PITCH));
        } else {
            Vector3f effect = this.getWindEffect();
            this.method_36457(this.method_36455() + effect.x);
            this.method_36456(this.method_36454() + effect.z);
            float offsetStrength = 0.005f;
            this.method_18799(this.method_18798().method_1031((double)(effect.x * offsetStrength), 0.0, (double)(effect.z * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().get(VehicleStat.WIND);
        float thundering = this.method_37908().method_8430(0.0f);
        float raining = this.method_37908().method_8478(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.method_18798().method_1033() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public Vector3f getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.field_6012 / 20.0 / (double)this.getProperties().get(VehicleStat.MASS)) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.field_6012 / 21.0 / (double)this.getProperties().get(VehicleStat.MASS)) * (double)wind);
        return new Vector3f(nx, 0.0f, nz);
    }
}

